const clientSystem = client.registerSystem(0, 0);

let query = null

let gameTicks = 0

let entityId = 'minecraft:creeper'

// Setup which events to listen for
clientSystem.initialize = function () {
  this.initLogger()
  query = this.registerQuery()
}

// per-tick updates
clientSystem.update = function() {
  gameTicks++

  let entities = this.getEntitiesFromQuery(query)
  for (let entity of entities) {
    if (this.isValidEntity(entity) && entity.__identifier__ === entityId) {
      // 1 (Second run). Uncomment the following line, then run
      // let molangComponent = this.getComponent(entity, 'minecraft:molang')

      // 2 (Third run). Uncomment the following few lines, and run again
      // if (molangComponent) {
      //   molangComponent.data['variable.foo'] = 1

      //   this.applyComponentChanges(entity, molangComponent)
      // }
    }
  }
}

clientSystem.initLogger = function () {
  const loggerEvent = this.createEventData('minecraft:script_logger_config')
  loggerEvent.data.log_errors = true
  loggerEvent.data.log_warnings = true
  loggerEvent.data.log_information = true
  this.broadcastEvent('minecraft:script_logger_config', loggerEvent)
}
